#include <stdlib.h>
#include <stdio.h>

// definitions of: SCALAR, BLOCK_SIZE_S, BLOCK_SIZE_L and ALIGNMENT
#include "sizes.h"

void mat_mul_par(SCALAR *a, SCALAR *b, SCALAR* c, int n)
{
  int i,j,k;
  const int BLS = BLOCK_SIZE_S;
   
  // matrix c initialized in mat_mul_driver.c
/* #pragma omp parallel for default(none) shared(c,n) private(i,j) */
/*   for(i=0;i<n;i++){ */
/*     for(j=0;j<n;j++){ */
/*       c[i*n+j]=0.0; */
/*     } */
/*   } */

//#pragma omp parallel for default(none) shared(a,b,c,n) private(i,j,k)
  for(i=0;i<n;i++){
    for(k=0;k<n;k++){
      for(j=0;j<n;j++){
	c[i*n+j] += a[i*n+k]*b[k*n+j];
      }
    }
  }

  return;
}
